#include "LedMatrixHelper.h"
#include "ChestsTrigonometryHelper.h"

#include <ESP8266WiFi.h>
#include <ESP8266HTTPClient.h>
#include <WiFiUdp.h>
#include <PubSubClient.h>
#include <ArduinoJson.h> 
#include <string.h>
#include <Servo.h>

//C'est cadeau pour vous éviter de vous taper du parsing à la main en C :p 
String getSubTopicAtIndex(String topic, int index) {
  int found = 0;
  int strIndex[] = {0, -1};
  int maxIndex = topic.length()-1;
  for(int i=0; i<=maxIndex && found<=index; i++){
    if(topic.charAt(i)=='/' || i==maxIndex){
        found++;
        strIndex[0] = strIndex[1]+1;
        strIndex[1] = (i == maxIndex) ? i+1 : i;
    }
  }
  return found>index ? topic.substring(strIndex[0], strIndex[1]) : "";
}

Servo compassServo;


// ####### 1.a. CONFIGURATION ET DECLARATION DU HOSTPOT WIFI #######
char ssid[] = "NOM DU RESEAU";     //  le nom du reseau WIFI
char password[] = "MOT DE PASSE";  // le mot de passe WIFI
WiFiClient espClient;

// ####### 1.b. DECLARATION DU CLIENT HTTP ET DES VARIABLES DE STOCKAGE DES DONNÉES DE JEU #######
HTTPClient http;
int teamPixelArt[8][8];
StaticJsonDocument<2048> requiredChestsDoc;
JsonArray requiredChests = requiredChestsDoc.to<JsonArray>();

// ####### 2.a. CONFIGURATION ET DECLARATION DU SERVEUR MQTT #######
char mqtt_server[] = "IP OU ADRESSE DU SERVEUR";  //adresse IP serveur 
#define MQTT_USER ""
#define MQTT_PASS ""
PubSubClient MQTTclient(espClient);


// ####### 1.c. ACQUISITION DU PIXEL ART VIA REQUETE HTTP ET LECTURE DU JSON #######
void fetchTeamPixelArt() {
  /* TODO */
}

// Fonction simple mais si ça peut vous permettre de gagner 2 minutes :)
bool isColorInTeamPixelArt(int color) {
  for (int i = 0; i < 8; i++) {
    for (int j = 0; j < 8; j++) {
      if (teamPixelArt[i][j] == color) return true;         
    }
  }
  return false;
}

// ####### 1.d. ACQUISITION DES COFFRES COMPORTANT LES COULEURS DONT NOUS AVONS BESOIN #######
void fetchRequiredChests() {
  /* TODO */
}






void MQTTconnect() {
  while (!MQTTclient.connected()) {
      Serial.print("Attente de la connexion MQTT....");
      String clientId = "TestClient-";
      clientId += String(random(0xffff), HEX);

    // test connexion
    if (MQTTclient.connect(clientId.c_str(),"","")) {
      Serial.println("connected");

      // ####### 2.b. SOUSCRIPTION AUX TOPICS MQTT DE MON/MES JOUEURS #######        
      /* TODO */

    } else {  // si echec affichage erreur
      Serial.print("ECHEC, rc=");
      Serial.print(MQTTclient.state());
      Serial.println(" nouvelle tentative dans 5 secondes");
      delay(5000);
    }
  }
}

void MQTTcallback(char* topic, byte* payload, unsigned int length) {
  Serial.print("Message MQTT reçu sur [");
  String topicString = String((char*)topic);
  Serial.print(topicString);
  Serial.println("] ");
  payload[length] = '\0';

  // ####### 2.b. "AIGUILLAGE" DES MESSAGES MQTT SELON LES TOPICS #######
  // Vous pouvez utiliser la fonction getSubTopicAtIndex(topicString, VOTRE_INDEX)
  // Par exemple getSubTopicAtIndex(topicString, 1) retournera "AntoineRcbs" 
  // pour l'entrée topicString = "redTeam/AntoineRcbs/location"
  /* TODO */
}


// ####### 2.c. Décodage de la donnée (numéro du block de construction tenu) et mise à jour de l'affichage #######
// On pourra prendre un DynamicJsonDocument de taille 128
void onConstructionItemHeld(byte* payload, unsigned int length) {
  /* TODO */
}



// ####### 2.c. Décodage du JSON et traitement sur les données extraites pour servo (+bonus affichage) #######
// On pourra prendre un DynamicJsonDocument de taille 128
void onPlayerLocationUpdate(byte* payload, unsigned int length) {
  /* TODO */  
}



void setup() { 
  initLedMatrix();
  compassServo.attach(D4, 300, 2700);
  Serial.begin(115200);

  // ####### 1.a. CONNEXION AU WIFI #######
  /* TODO */

  // ######## 1.c. REQUETE HTTP POUR PIXEL ART ########
  /* TODO */

  // ######## 1.d. REQUETE HTTP POUR COFFRES ########
  /* TODO */
   

  // ####### 2.a. INITIALISATION DU SERVEUR ET DU CALLBACK MQTT #######
  /* TODO */
}

void loop() {

  // ####### 2.a. RECONNEXION ET POOLING LOOP MQTT #######  
  /* TODO */
}