#include "ChestsTrigonometryHelper.h"

double getHorizontalDistanceToRequiredChest(JsonArray requiredChests, int requiredChestIdx, double px, double pz) {
  if (requiredChestIdx >= requiredChests.size()) return -1.0;
  double cx = requiredChests[requiredChestIdx]["location"]["x"].as<double>();
  double cz = requiredChests[requiredChestIdx]["location"]["z"].as<double>();
  return sqrt(pow(cx-px, 2) + pow(cz-pz, 2));
}

double getVerticalDistanceToRequiredChest(JsonArray requiredChests, int requiredChestIdx, double py) {
  if (requiredChestIdx >= requiredChests.size()) return -1.0;  
  double cy = requiredChests[requiredChestIdx]["location"]["y"].as<double>();
  return abs(cy-py);
}

double getAngleDirectionDifferenceToRequiredChest(JsonArray requiredChests, int requiredChestIdx, double px, double pz, double pRot) {
  if (requiredChestIdx >= requiredChests.size()) return -1.0;  
  double cx = requiredChests[requiredChestIdx]["location"]["x"].as<double>();
  double cz = requiredChests[requiredChestIdx]["location"]["z"].as<double>();
  double angle = pRot - (atan2(px-cx, cz-pz)*180.0/3.1415);
  if (angle <= -180.0)  angle+=360.0;
  else if (angle >= 180.0) angle-=360.0;
  return angle;
}