# Formation Web partie 2 : Client HTTP et MQTT sur ESP8266

## Prérequis

### Inclure la famille des ESP dans l'IDE Arduino

- Aller dans File > Preferences et ajouter ```http://arduino.esp8266.com/stable/package_esp8266com_index.json``` dans le champ "Additional boards manager URLs".

- Aller dans tools > Boards > Boards Manager puis rechercher esp et installer "esp8266".

### Bibliothèques à télécharger sur l'IDE Arduino

Aller dans Sketch > Include Library > Manage Libraries et ajouter les bibliothèques suivantes :

- MD_Parola
- cloud4rpi-esp-arduino

### Selection de l'environnement

- Brancher l'ESP8266 à votre PC
- Dans Tools > boards > esp8266, choisir "NodeMCU 1.0 (ESP-12E Module)"
- Choisir dans Tools > port le port série correspondant à votre ESP.
- Essayez de téléverser le programme pour voir si tout fonctionne bien (compilation et liaison avec l'ESP)
- Ouvrir la console série. Configurée le baudrate à 115200.

## Mise en place du réseau

Merci de réserver le réseau Wifi qui sera indiqué par l'encadrant uniquement si vous êtes joueur et pour les ESP8266. Pour les PC de développement, utiliser Eduroam.

## Duplication du code

- Ouvrez un terminal à l'emplacement où vous souhaitez travaillez.
- Clonnez ce repertoire git.
- Ouvrez le projet "formation_web_esp" avec l'IDE Arduino.

Ce code sera notre base par la suite. Il contient la structure avec laquelle on évoluera ainsi que des fonctions que vous pourrez utiliser par la suite.

## Partie 1 - Faisons une requête HTTP !

### A - Connexion au WiFi

Changer les valeurs ssid et password pour correspondre au Wifi auquel on souhaite se connecter.

Dans le setup() (fonction exécutée une seule fois lors du démarrage de la carte), renseigner le code permettant d'établir la connexion au Wifi.

On souhaite attendre tant qu'on est pas connecté. Lors de l'attente on imprimera des "." dans la console (sans sauter de ligne) toutes les 500ms.

Une fois connecté, on souhaite afficher un message indiquant que la connexion est un succès.
- ```Wifi.begin(ssid, password);``` permet de lancer le processus de connexion au WiFi donné.
- ```WiFi.status() != WL_CONNECTED``` permet de vérifier si on est connecté.
- ```delay(temps_en_ms);``` permet d'attendre un temps donné.
- ```Serial.print("mon message");``` permet d'écrire dans la console. ```Serial.println("mon message");``` fait pareil mais en sautant une ligne à la fin.

### B - Déclaration du client HTTP et des variables de stockage des données de jeu

Regarder le code de déclaration de variables correspondant. Voir avec le formateur pour la contextualisation des attendues sur ces variables.

###  C - Faire une requète HTTP pour récupérer le pixel art de votre équipe.

Commencer par regarder avec un indicateur la "tronche" de la donnée (via le formateur car vous n'aurez pas accès au réseau local avec vos PC de dev).

Implémenter la fonction fetchTeamPixelArt() pour qu'elle fasse la requête HTTP nécessaire, lise le JSON et extraie dans le tableau d'int teamPixelArt[][] les données qui nous intéressent. 

On adoptera la structure suivante pour la requête HTTP et sa conversion en objet lisible par ArduinoJson.

```Arduino
    http.useHTTP10(true);
    http.begin(espClient, "MON ADRESSE HTTP");
    http.GET();
    DynamicJsonDocument doc(2048);
    deserializeJson(doc, http.getStream());  
    // ICI LE CODE D'EXTRACTION DE DONNÉES
    http.end();
```

Le JSON récupéré comporte la donnée qui nous intéresse dans un champs "pixelArt", à sa racine. Ce champ est un tableau JSON. On peut utiliser l'objet JsonArray fourni par ArduinoJson pour travailler avec.
Nous travaillons avec un Stream ici. pour extraire le tableau JSON du pixel art vous pouvez utiliser :
```Arduino
JsonArray teamPixelArtArray = doc["pixelArt"].as<JsonArray>();
```
Vous pouvez ensuite parcourir ce tableau 2D comme un tableau classique (via boucle for...). Vous pouvez utiliser ```teamPixelArtArray.size();``` et ```teamPixelArtArray[0].size();```

La ligne suivante vous permettra, par exemple, de mettre à jour notre int[][] avec les données issues du tableau JSON qu'on est en train de parcourir.
```Arduino
teamPixelArt[i][j] = teamPixelArtArray[i][j].as<int>();
```

**Profitez du parcours de ce tableau pour afficher les valeurs dans le tableau.** Vous pouvez utiliser ```Serial.print(" ");``` entre chaque case et  ```Serial.println(); ``` entre chaque ligne.

N'oubliez pas d'appeler cette fonction ```fetchTeamPixelArt()``` dans le ```setup()``` à l'endroit indiqué.

**Vous pouvez maintenant lancer votre code (pas trop loin hihi) et admirer le résultat !**

### D - Acquisition des données sur les coffres. Filtrage pur ne mémoriser que les coffres utiles

De même que dans le cas précédent, étudier avec le formateur la "tronche" de la donnée correspondant.

Mettre en place le code pour faire la requête HTTP et faire la deserialization du JSON. Le document fera une taille de 4096 octets (pour prendre très large...)

Nous avions instancié un JsonArray pour stocker les coffres qui nous intéressent. Il faut en revanche faire le tri. Le Json que l'on récupère est un tableau. Une fois "converti" au bon format, on peut donc le parcourir !

```Arduino
JsonArray chestArray = doc.as<JsonArray>();
  for (JsonObject chest : chestArray) {
    //Ajout du coffre au JsonArray requiredChests s'il nous intéressent. 
  }
```

Pour faire le tri, vous pouvez utiliser la fonction ```isColorInTeamPixelArt(int color)``` qu'on vous a gracieusement déjà implémenté. La couleur du matériau contenu dans un coffre est contenu dans le champs "content".
Pour ajouter un coffre au tableau requiredChests, vous pouvez utiliser ```requiredChests.add(chest);```.

Une fois le tri fait, parcourez votre tableau requiredChests et affichez dans le terminal série les infos qui vous intéressent (les champs "name", "x", "y", "z" et "content"). Vous êtes libre de formatez comme vous voulez (de toute façon c'est vous qui jouez !)

N'oubliez pas d'appeler cette fonction ```fetchRequiredChests()``` dans le ```setup()``` à l'endroit indiqué.


** C'est fini ! Voyez avec l'intructeur pour le déroulement de la première partie ;)**


## Partie 2 - Des données en temps réel grâce au protocole MQTT !

### A - Connexion au broker MQTT

Mettez à jour l'adresse du broker MQTT avec celle donnée par le formateur.

Dans le setup(), rajoutez les lignes suivantes et discutez-en.

```Arduino
MQTTclient.setServer(mqtt_server, 1883);
MQTTclient.setCallback(MQTTcallback);
```

Regardez la fonction ```MQTTconnect()``` déjà implémentée. Discutez-en.
Faites de même avec la fonction ```MQTTCallback```

Dans le ```loop()``` (fonction exécutée en boucle infinie juste après le ```setup()```), appellez la fonction ```MQTTconnect()``` si on est déconnecté du broker MQTT. 

On peut vérifier que l'on est connecté au broker via ```MQTTclient.connected()```;

Juste après cette vérification, ajoutez la ligne suivante dans votre ```loop()```.
```Arduino
MQTTclient.loop();
```
Elle permet d'interragir avec le MQTT de manière synchrone.

**Vous pouvez tester pour voir si la connexion se fait bien.**


### B - Souscrivons aux topics et "aiguillons" la donnée pour la traiter !

Souscrivez aux topics qui vous intéresent (localisation et item de construction tenu en main de vos joueurs). Vous devez implémenter la souscription dans la fonction ```MQTTConnect()``` à l'emplacemen indiqué.

La souscription se fait, par exemple, via l'appel suivant : 
```Arduino
MQTTclient.subscribe("redTeam/AntoineKia/location"); //Pour un topic précis
// OU
MQTTclient.subscribe("redTeam/AntoineKia/#"); //Pour tous les sous-topics à partir de l'endroit indiqué.
```

**Vous pouvez tester et constater que vous recevez bien la donnée.**

La souscription est faite, il faut désormais traiter l'information. Pour cela, on va mettre à jour le ```MQTTCallback``` (fonction appellée à chaque fois qu'on reçoit une mise à jour sur un topic donné).

En fonction du topic recu, vous devez appeler soit la fonction ```onConstructionItemHeld(byte* payload, unsigned int length)``` soit ```onPlayerLocationUpdate(byte* payload, unsigned int length)```.
Vous pouvez vous aider de la fonction ```getSubTopicAtIndex(String topicString, int index)``` déjà fournie et implémentée.

### C - Assister la construction du pixel art via la matrice LED.

Le topic ```"last-selected-construction-item``` ne contient pas un JSON mais simplement le numéro du dernier matériau de construction tenu en main par un joueur donné. La ligne de code suivante vous permettra de la récupérer sous forme d'int :
```Arduino
int itemId = atoi((char*)payload);
```
Affichez avec un joli message cette donnée dans la console série.

Utilisez ensuite l'appel suivant :
```drawMatrix(teamPixelArt, itemId);```

Cette fonction, qu'on vous fournit, permet d'allumer les pixels correspondant au matériau donné dans le pixel art donné. Testez de changer d'item dans la main, vous devriez alors voir l'allumage changer.

### D - Orienter le joueur grace à la boussolle/servo moteur. 

Implementez maintenant la fonction ```onPlayerLocationUpdate(byte* payload, unsigned int length)```. La donnée reçue dans le payload est un JSON.

Le JSON n'est plus donné sous forme de Stream mais de tableau d'octets. Il s'opère différament. Pour extraire les coordonnées et la direction dans laquelle regarde le joueur, vous pouvez donc utiliser le code suivant.

```Arduino
DynamicJsonDocument playerLocation(128);
deserializeJson(playerLocation, payload, length);
double x, y, z, rot;
x = playerLocation["x"];
y = playerLocation["y"];
z = playerLocation["z"];
rot = playerLocation["rotation"];
```

**Vous pouvez afficher cette donnée dans la console série pour vérifier que tout va bien.**

Il faut désormais controler la bousolle pour qu'elle oriente notre joueur. Cela peut se faire via un appel simple :
```Arduino
compassServo.write(servoAngle); 
```
Avec servoAngle un entier entre 0 et 180.

Regardez la fonction ```getAngleDirectionDifferenceToRequiredChest(JsonArray requiredChests, int requiredChestIdx, double px, double pz, double pRot)```. Elle permet, pour un JsonArray de coffres donné, un index dans ce tableau donné et pour des coordonnées de joueur donné, d'obtenir l'angle entre la direction dans laquelle le joueur regarde et la direction du coffre. 

On va utiliser cet angle pour orienter notre boussolle/servo.
Cependant, l'angle retourné par cette fonction est entre -180 et 180 degrés. Or le servo ne peut tourner que sur une amplitude de 180 degrés.

De plus, l'angle donné est un flottant (double), or la fonction qui exploite le servo prend un entier. Il faut donc "caster" l'angle en int, le "tronquer", via les fonctions ```max(a, b)``` et ```min(a, b)```, puis lui ajouter 90;


**On dirait bien que vous êtes prêt à jouer en utilisant uniquement l'objet connecté !**


## BONUS :

- Comment changer de coffre ciblé ? Dans le TP, on "hardcodait". Peut-on faire mieux ? Imaginez ! Explorez !

- Le ChestsTrigonometryHelper vous donne des fonctions pour avoir la distance de votre joueur à un coffre donné. Vous pouvez vous en servir pour afficher une aide sur la matrice de LED. Vous pouvez vous inspirer des fonctions existantes dans le LedMatrixHelper.

