#!/usr/bin/env bash

# Check args
if [ "$#" -ne 3 ]; then
  echo "usage: ./run.sh IMAGE_NAME CONTAINER_NAME WORKSPACE"
  exit 1
fi

if [ ${3:0:1} == '/' ]; then
    workspace_path=$3
else
    workspace_path=`pwd`/$3
fi

# Get this script's path
pushd `dirname $0` > /dev/null
SCRIPTPATH=`pwd`
popd > /dev/null

set -e


XAUTH=/tmp/.docker.xauth
if [ ! -f $XAUTH ]
then
    xauth_list=$(xauth nlist :0 | sed -e 's/^..../ffff/')
    if [ ! -z "$xauth_list" ]
    then
        echo $xauth_list | xauth -f $XAUTH nmerge -
    else
        touch $XAUTH
    fi
    chmod a+r $XAUTH
fi

# Run the container with shared X11
if [ -z DOCKER_NVIDIA ]; then
    sudo docker run\
      --privileged\
      --rm\
      --net=host\
      -e SHELL\
      --env="DISPLAY=$DISPLAY"\
      --env="QT_X11_NO_MITSHM=1"\
      -env="XAUTHORITY=$XAUTH"\
      --volume="$XAUTH:$XAUTH"\
      --volume="/tmp/.X11-unix:/tmp/.X11-unix:rw" \
      --volume="${workspace_path}:${HOME}/workspace" \
      -e DOCKER=1\
      --name $2 \
      --runtime=nvidia \
      -it $1 bash
else
    sudo docker run\
      --privileged\
      --rm\
      --net=host\
      -e SHELL\
      --env="DISPLAY=$DISPLAY"\
      --env="QT_X11_NO_MITSHM=1"\
      -env="XAUTHORITY=$XAUTH"\
      --volume="$XAUTH:$XAUTH"\
      --volume="/tmp/.X11-unix:/tmp/.X11-unix:rw" \
      --volume="${workspace_path}:${HOME}/workspace" \
      -e DOCKER=1\
      --name $2 \
      -it $1 bash
fi
