var blocklyDiv = document.getElementById('blocklyDiv');
var blocklyArea = document.getElementById('blocklyArea');

var xml = null;
var request = new XMLHttpRequest();
request.open('GET', 'toolbox.xml', false);
request.send();
if (request.readyState == 4 && request.status == 200) {
  xml = request.responseXML;
}
var toolbox = new XMLSerializer().serializeToString(xml.documentElement);
var workspace = Blockly.inject(blocklyDiv,
      {toolbox: toolbox});

//Ca a l'air dégueulasse pour faire du responsive mais c'est le truc de la doc
//officielle de google xD
var onresize = function(e) {
	// Compute the absolute coordinates and dimensions of blocklyArea.
    var element = blocklyArea;
    var x = 0;
    var y = 0;
    do {
      x += element.offsetLeft;
      y += element.offsetTop;
      element = element.offsetParent;
    } while (element);
    // Position blocklyDiv over blocklyArea.
    blocklyDiv.style.left = x + 'px';
    blocklyDiv.style.top = y + 'px';
    blocklyDiv.style.width = blocklyArea.offsetWidth + 'px';
    blocklyDiv.style.height = blocklyArea.offsetHeight + 'px';
    Blockly.svgResize(workspace);
  };
  window.addEventListener('resize', onresize, false);
  onresize();
  Blockly.svgResize(workspace);


//Lance le code tel que rentré par le joueur
function runCode() {
	var code = Blockly.JavaScript.workspaceToCode(workspace); //On récupère un code javascript
	var myInterpreter = new Interpreter(code, initApi); //Intanciation d'une VM avec fonctions réécrites
	myInterpreter.run(); //On lance le code de l'utilisateur dans la VM
  //Il est possible de lancer le code de façon séquencielle
}

//Interprétation des commandes par l'utiliseur (redéfinition des fonctions avec IO)
function initApi(interpreter, scope) {
	// Add an API function for the alert() block.
	var wrapper = function(text) {
		return alert(arguments.length ? text : '');
	};
	interpreter.setProperty(scope, 'alert',
	interpreter.createNativeFunction(wrapper));

	// Add an API function for the prompt() block.
	wrapper = function(text) {
		return prompt(text);
	};
	interpreter.setProperty(scope, 'prompt',
	interpreter.createNativeFunction(wrapper));
}
