var blocklyDiv = document.getElementById('blocklyDiv');
var blocklyArea = document.getElementById('blocklyArea');
var connectButton = document.getElementById('connectButton');

var receivedMsg = "";

var port;
let textEncoder = new TextEncoder();

//Chargement de la toolbox
var xml = null;
var request = new XMLHttpRequest();
request.open('GET', 'toolbox.xml', false);
request.send();
if (request.readyState == 4 && request.status == 200) {
  xml = request.responseXML;
}
var toolbox = new XMLSerializer().serializeToString(xml.documentElement);

//Instancie l'espace de travail blockly
var workspace = Blockly.inject(blocklyDiv,
      {toolbox: toolbox});

/* Adapte la taille du conteneur de l'espace du travail à l'environnement
Ca a l'air dégueulasse pour faire du responsive mais c'est le truc de la doc
officielle de google xD*/
var onresize = function(e) {
	// Compute the absolute coordinates and dimensions of blocklyArea.
    var element = blocklyArea;
    var x = 0;
    var y = 0;
    do {
      x += element.offsetLeft;
      y += element.offsetTop;
      element = element.offsetParent;
    } while (element);
    // Position blocklyDiv over blocklyArea.
    blocklyDiv.style.left = x + 'px';
    blocklyDiv.style.top = y + 'px';
    blocklyDiv.style.width = blocklyArea.offsetWidth + 'px';
    blocklyDiv.style.height = blocklyArea.offsetHeight + 'px';
    Blockly.svgResize(workspace);
  };
  window.addEventListener('resize', onresize, false);
  onresize();
  Blockly.svgResize(workspace);

//Instanciation de la liaison série à la fin du chargement de la page
document.addEventListener('DOMContentLoaded', event => {
  function connect() {
    console.log('Connecting to ' + port.device_.productName + '...');
    port.connect().then(() => {
      console.log(port);
      console.log('Connected.');
      connectButton.textContent = 'Se déconnecter';
      port.onReceive = data => {
        let textDecoder = new TextDecoder();
        receivedMsg = textDecoder.decode(data);
        //console.log("Reçu :" + receivedMsg);
      }
      port.onReceiveError = error => {
        console.log('Receive error: ' + error);
      };
    }, error => {
      console.log('Connection error: ' + error);
    });
  };

  connectButton.addEventListener('click', function() {
    if (port) {
      port.disconnect();
      connectButton.textContent = 'Connecter à la maquette';
      port = null;
    } else {
      serial.requestPort().then(selectedPort => {
        port = selectedPort;
        connect();
      }).catch(error => {
        console.log('Connection error: ' + error);
      });
    }
  });

  serial.getPorts().then(ports => {
    if (ports.length == 0) {
      console.log('No devices found.');
    } else {
      port = ports[0];
      connect();
    }
  });
});


//Envoie ce string à l'Arduino
function sendString(str) {
  if (port !== undefined) {
    port.send(textEncoder.encode(str)).catch(error => {
      console.console.log('Send error: ' + error);
    });
  }
}

//Attend jusqu'à ce que le message "UNLOCK;" soit reçu de l'arduino
function waitForUnlockFromArduino() {
  if (receivedMsg != "UNLOCK;") {
    setTimeout(waitForUnlockFromArduino, 10);
    return;
  }
}

//Lance le code tel que rentré par le joueur
function runCode() {
	var code = Blockly.JavaScript.workspaceToCode(workspace); //On récupère un code javascript
	var myInterpreter = new Interpreter(code, initApi); //Intanciation d'une VM avec fonctions réécrites
	myInterpreter.run(); //On lance le code de l'utilisateur dans la VM
  //Il est possible de lancer le code de façon séquencielle
}


//Interprétation des commandes par l'utiliseur (redéfinition des fonctions avec IO)
function initApi(interpreter, scope) {
	// Add an API function for the alert() block.
	var wrapper = function(text) {
		return alert(arguments.length ? text : '');
	};
	interpreter.setProperty(scope, 'alert',
	interpreter.createNativeFunction(wrapper));

  // Add an API function for the sendString() block.
	wrapper = function(text) {
		return sendString(arguments.length ? text : '');
	};
	interpreter.setProperty(scope, 'sendString',
	interpreter.createNativeFunction(wrapper));

  // Add an API function for the waitForUnlockFromArduino() block.
  wrapper = function() {
		return waitForUnlockFromArduino();
	};
	interpreter.setProperty(scope, 'waitForUnlockFromArduino',
	interpreter.createNativeFunction(wrapper));
}
