<h1>Démo</h1>

**Une démo du projet est présente ici :** www.antoine-rcbs.ovh/apollo

<h1>Présentation du projet

Ce projet vise à faire un atelier en partenariat avec l'Institut Gaston Berger autour de Apollo 11.
L'objectif est de **faire découvrir des bases de programmation** et de montrer que l'informatique ne se limite pas aux programmes tournant sur des PC !
Les élèves participant à l'atelier font l'une des 4 activités proposées. Pour chacune, il faut coder en code visuel un petit programme. Ce code communique ensuite avec celui
d'un arduino contrôlant une **maquette branchée à l'ordinateur** (une maquette par activité.) L'idée étant de f**aire interagir les élèves avec du Hardware et du Software en même temps de façon
simple et ludique**
.

Ce projet emploie donc les lib **Blockly** et **JS-Interpreter** pour faire tourner le code côté ordinateur.
Pour chaque module, le **code de la maquette est donné en Arduino**.
La communication entre les deux se fera par une lib dont le choix est encore à faire.

Chaque groupe d'élèves participe à deux ateliers (mode tournant.) A la fin, la réalisation de chaque atelier par les élèves donne lieu à une séquence commune de "victoire"
(animation avec maquette, etc) **=> Idée à préciser**



<h1>Liste des activités

**TODO :** on est sur de ça ? Refaire un point rapidement avant que ça parte en prod...


<h2>Charger le carburant dans la fusée

TODO : préciser l'activité


<h2>Contrôler l'inclinaison des moteurs pendant la monté

TODO : préciser l'activité


<h2>Se placer sur la bonne orbite/injection trans-lunaire

TODO : préciser l'activité


<h2>Montrer les premiers pas de l'homme à toute l'humanité + recevoir l'appel de Nixon

TODO : préciser l'activité



<h1>Consignes d'exécution et de clone

En raison de la présence de lib externes, il faut bien **penser à clone en utilisant la commande suivante** : <br/>
`git clone --recurse-submodules https://gitlab.clubelek.fr/antoinekia/atelier_igb_apollo/`

**A faire sinon les modules Blockly ne marcheront pas  !!!**
Les scripts JS utilisent des requêtes HTTP. Tout navigateur digne de ce nom les bloque si l'URL commence par "files://", il faut donc lancer un serveur http sur sa machine pour tester.
Cela se fait très facilement si python est installé correctement en lançant la commande suivante dans le répertoire racine du projet : <br/>
`python -m SimpleHTTPServer`



<h1>Utilisation de Blockly dans ce projet

Explication de l'architecture plus détaillée à venir. Là j'ai un peu la flemme de le faire par écrit :/
En gros : **pour chaque activité il y a :**

*  Un **script JS (main-script.js)** gérant l'instanciation de Blockly, l'interprétation des fonctions IO employées par le code utilisateur, le lancement du code utilisateur, etc... Bref, il fait le café
*  Un **fichier toolbox.xml**. Ce fichier peut très facilement être généré par un outil officiel mis en place par google. Idem pour les blocs customs ;)
*  Un **fichier HTML (index.html) contenant la page** dédiée à l'activité.

La doc officielle est très bien fichue et est dispo ici : https://developers.google.com/blockly/guides/get-started/web

Le plus gros du travail de conception est de **créer des blocs customs pour les actions** (capteurs/actionneurs de la maquette, éléments visuels d'interface etc) et de **définir la toolbox** pour chaque activité.
Cela se fait sur l'**interface en ligne** : https://blockly-demo.appspot.com/static/demos/blockfactory/index.html

Dans le main-script.js, la fonction "initAPI" permet de "réécrire" le comportement de fonctions de base de JS à notre sauce en fonction de ce qu'on veut faire. (envoi aux arduino d'un msg, etc)



<h1>Interactions avec les modules Arduino

**TODO (j'en ai pas sous la main là pour tester :'( )**
