<h1>Démo</h1>

**Une démo du projet est présente ici :** www.antoine-rcbs.ovh/apollo

<h1>Présentation du projet</h1>

Ce projet vise à faire un atelier en partenariat avec l'Institut Gaston Berger autour de Apollo 11.
L'objectif est de **faire découvrir des bases de programmation** et de montrer que l'informatique ne se limite pas aux programmes tournant sur des PC !
Les élèves participant à l'atelier font l'une des 4 activités proposées. Pour chacune, il faut coder en code visuel un petit programme. Ce code communique ensuite avec celui
d'un arduino contrôlant une **maquette branchée à l'ordinateur** (une maquette par activité.) L'idée étant de **faire interagir les élèves avec du Hardware et du Software en même temps de façon
simple et ludique**
.

Ce projet emploie donc les lib **Blockly** et **JS-Interpreter** pour faire tourner le code côté ordinateur.
Pour chaque module, le **code de la maquette est donné en Arduino**.
La communication entre les deux se fera par l'utilisation de l'API **webUSB** (uniquement compatible Chrome > 61.0 et Opera pour l'instant.)

Chaque groupe d'élèves participe à deux ateliers (mode tournant.) A la fin, la réalisation de chaque atelier par les élèves donne lieu à une séquence commune de "victoire"
(animation avec maquette, etc) **=> Idée à préciser**



<h1>Liste des activités</h1>

Il y a quatres activités de prévues pour le moment (et c'est beaucoup mine de rien ^^')


<h2>Charger le carburant dans la fusée</h2>

Il faut charger les différents types de carburant dans la fusée : oxygène liquide, RP1 (kérosène) et hydrogène.
Il y a 6 réservoirs (3 oxygène, 1 gros kerosène, 2 petits hydrogène) à remplir sur la fusée. Il faudra le faire en s'assurant de bien atteindre le niveau requis sans déborder en conservant une bonne température.

<h3>Hardware : </h3>

Pour le hardware, l'arduino leonardo (pro micro) contrôle des pompes peristaltiques et reçoit des informations de capteurs tout ou rien pour le remplissage.
Il y a **3 réservoirs de stockage des carburants** (eau + colorant alimentaire) sur un pas de tir. 
La fusée (**maquette en vue de coupe imprimée en 3D**) est consituée de **3 étages comportant 2 réservoirs chacuns**. Ils sont reliés aux réservoirs du pas de tir et aux pompes par des tuyaux.

**Achats effectués :**

- Ponts en H : https://www.aliexpress.com/item/4000004181117.html?spm=a2g0s.9042311.0.0.1e704c4dPCKkFD
- Pompes (x6) : https://www.aliexpress.com/item/32876392978.html?spm=a2g0s.9042311.0.0.1e704c4dPCKkFD
- Interrupteur flottant : https://www.aliexpress.com/item/32909017788.html?spm=a2g0s.9042311.0.0.1e704c4dPCKkFD



<h3>Software : </h3>

A préciser : Activité a priori simple sur le plan de la programmation : faire des actions en vérifiant des paramètres.
Faire remplir les étages un à un en ajoutant des critères de difficulté en plus à chaque fois ? (Exemple : 1er étage juste à mettre en route, 2e surveiller le remplissage pour
pas déborder et 3e remplissage + température etc) ?


<h2>Faire décoller la fusée en séparrant les étages/ajustant la poussée/la direction des moteurs</h2>

TODO : préciser l'activité
Maquette en 3D/carton. Représentation très schématique en 3D. Avoir une jauge de hauteur et une d'inclinaison de fusée (ou représentation graphique sur écran de la trajectoire) 

<h2>Montrer les premiers pas de l'homme à toute l'humanité (+ recevoir l'appel de Nixon ?)</h2>

TODO : préciser l'activité

On a déjà un téléphone rétro qui fonctionne (on peut le faire sonner et parler/écouter) et j'ai commandé un module pour pouvoir lire des MP3 dans le combiné.



<h2>Rendez-vous orbital autour de la Lune</h2>

Faire la manoeuvre de docking du module lunaire et du module de service en orbite lunaire avant de rejoindre la Terre.

TODO : préciser l'activité



<h1>Consignes d'exécution et de clone</h1>

En raison de la présence de lib externes, il faut bien **penser à clone en utilisant la commande suivante** : <br/>
`git clone --recurse-submodules https://gitlab.clubelek.fr/antoinekia/atelier_igb_apollo/`

**A faire sinon les modules Blockly ne marcheront pas  !!!**
Les scripts JS utilisent des requêtes HTTP. Tout navigateur digne de ce nom les bloque si l'URL commence par "files://", il faut donc lancer un serveur http sur sa machine pour tester.
Cela se fait très facilement si python est installé correctement en lançant la commande suivante dans le répertoire racine du projet : <br/>
`python -m SimpleHTTPServer`



<h1>Utilisation de Blockly dans ce projet</h1>

Explication de l'architecture plus détaillée à venir. Là j'ai un peu la flemme de le faire par écrit :/
En gros : **pour chaque activité il y a :**

*  Un **script JS (main-script.js)** qui contient les éventuels fonctions spécifiques à cette activité (affichages etc)
*  Un **fichier toolbox.xml**. Ce fichier peut très facilement être généré par un outil officiel mis en place par google. Idem pour les blocs customs ;)
*  Un **fichier HTML (index.html) contenant la page** dédiée à l'activité.

La doc officielle est très bien fichue et est dispo ici : https://developers.google.com/blockly/guides/get-started/web

Le plus gros du travail de conception est de **créer des blocs customs pour les actions** (capteurs/actionneurs de la maquette, éléments visuels d'interface etc) et de **définir la toolbox** pour chaque activité.
Cela se fait sur l'**interface en ligne** : https://blockly-demo.appspot.com/static/demos/blockfactory/index.html

Le dossier res contient le maximum de ressources communes aux activités (feuilles de style, header, footer, etc). Le fichier activities_functions.js contient les fonctions de bases communes à chauque activité (instanciation de blockly, interprétation du code, connexion usb à l'arduino, fonctions d'échange par liaisons série de base, etc)
Dans le activites_functions.js, la fonction "initAPI" permet de "réécrire" le comportement de fonctions de base de JS à notre sauce en fonction de ce qu'on veut faire. (envoi aux arduino d'un msg, etc)

L'architecture est assez sale (je suis un giga noob en web :/)


<h1>Interactions avec les modules Arduino</h1>

**Qui c'est le con qui a pas sauvegardé son code arduino ?...**

Le code blockly des blocks customs et l'Arduino s'envoient des messages par liaisons série sour le format "NOMFONCTION_ARG1_ARG2_..._ARGN;", il faut juste définir des actions à faire à leur réception dans les deux codes. 
