/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @fileoverview Generating JavaScript for dynamic variable blocks.
 * @author fenichel@google.com (Rachel Fenichel)
 */
'use strict';

goog.provide('Blockly.JavaScript.variablesDynamic');

goog.require('Blockly.JavaScript');
goog.require('Blockly.JavaScript.variables');


// JavaScript is dynamically typed.
Blockly.JavaScript['variables_get_dynamic'] =
    Blockly.JavaScript['variables_get'];
Blockly.JavaScript['variables_set_dynamic'] =
    Blockly.JavaScript['variables_set'];
