/* Insérer ici les fonctions spécifiques à cette activité. Elles peuvent marcher
avec les fonctions et variables déjà définies dans 'activity_functions.js' du
dossier 'res'.*/
var reedsStatus = {LH2 : false, LOX2 : false, RP1 : false, LOX1 : false}
var catchedFull = {LH2 : false, LOX2 : false, RP1 : false, LOX1 : false}
var catchTime = {LH2 : -1, LOX2 : -1, RP1 : -1, LOX1 : -1}
var stopTimeouts = {}
var circuitTemp = 5;

var checkReedsInterval = setInterval(function() {
  if (receivedMsg.startsWith('REEDS')) {
		reedsStatus = JSON.parse(receivedMsg.split('_')[1])
    //console.log(reedsStatus)
    for (var key of Object.keys(reedsStatus)) {
      if (reedsStatus[key] && catchTime[key] == -1) {
        catchTime[key] = Date.now()
        console.log("Catch tank plein de ", key)
      }
    }
  }
  for (var key of Object.keys(catchedFull)) {
    if (catchTime[key] != -1 && !catchedFull[key]) {
      if (Date.now() - catchTime[key] > 3000) {
        catchedFull[key] = true
        alert("Aïe Aïe Aïe ! Débordement non maitrisé !")
      }
    }
  }
}, 250);

function init_var() {
  catchedFull = {LH2 : false, LOX2 : false, RP1 : false, LOX1 : false}
  catchTime = {LH2 : -1, LOX2 : -1, RP1 : -1, LOX1 : -1}
  reedsStatus = {LH2 : false, LOX2 : false, RP1 : false, LOX1 : false}
  stopTimeouts = {}
  circuitTemp = 5
}
    
function getCircuitTemperature() {
  return circuitTemp
}

function coolCircuit() {
  circuitTemp -= 10
}

function isTankFull(tankId) {
  if (reedsStatus == null) return false
  if (reedsStatus[tankId]) {
    return true;
  }
}

function unloadFuel(tankId) {
  sendString("UNLOAD_" + tankId + ";")
}

function loadFuel(tankId) {
  sendString("LOAD_" + tankId + ";")
  console.log("load", tankId)
  if (stopTimeouts[tankId]) {
    if (stopTimeouts[tankId] != null)
      clearTimeout(stopTimeouts[tankId])
      stopTimeouts[tankId] = null
  }
  stopTimeouts[tankId] = setTimeout(() => {stopLoading(tankId);}, 2000)
}

function stopLoading(tankId) {
  console.log("stop fuel loading on", tankId)
  sendString("STOP_" + tankId + ";")
  if (reedsStatus[tankId]) {
    catchedFull[tankId] = true
  }
}