Blockly.Blocks['sendtoarduino'] = {
  init: function() {
    this.appendValueInput("MESSAGE")
        .setCheck("String")
        .appendField("Envoyer à l'arduino :");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(330);
 this.setTooltip("envoi d'un string à l'Arduino de la maquette");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['turn_led'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Mettre la LED en l'état")
        .appendField(new Blockly.FieldDropdown([["allumée","1"], ["éteinte","0"]]), "val");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(345);
 this.setTooltip("Change l'état d'une LED");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['arduino_wait'] = {
  init: function() {
    this.appendValueInput("time")
        .setCheck("Number")
        .appendField("Attendre");
    this.appendDummyInput()
        .appendField("secondes");
    this.setInputsInline(true);
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(330);
 this.setTooltip("");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['turn_io'] = {
  init: function() {
    this.appendValueInput("IO")
        .setCheck("Number")
        .appendField("Turn io");
    this.appendValueInput("VAL")
        .setCheck("Number")
        .appendField("to val");
    this.appendDummyInput();
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Outil de debug");
 this.setHelpUrl("");
  }
};

/* ACT 1*/

Blockly.Blocks['load_fuel'] = {
  init: function() {
    this.appendDummyInput()
        .setAlign(Blockly.ALIGN_CENTRE)
        .appendField("Charger le")
        .appendField(new Blockly.FieldDropdown([["RP1 (Kérosène) étage 1","RP1"], ["LH2 (Hydrogène) étage 2","LH2"], ["LOX (Oxygène) étage 1","LOX1"], ["LOX (Oxygène) étage 2","LOX2"]]), "fuel_type")
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Charge du carburant d'un type donné dans un étage donné");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['cool_circuit'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Refroidir les circuits LOX et LH2");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Permet de refroidir les circuits pour charger le carburant");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['get_circuit_temperature'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("température LOX et LH2 (°C)");
    this.setOutput(true, "Number");
    this.setColour(230);
 this.setTooltip("Donne la température des circuits de LOX et LH2");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_tank_full'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("le")
        .appendField(new Blockly.FieldDropdown([["RP1 (Kérosène) étage 1","RP1"], ["LH2 (Hydrogène) étage 2","LH2"], ["LOX (Oxygène) étage 1","LOX1"], ["LOX (Oxygène) étage 2","LOX"]]), "fuel_type")
        .appendField("est plein")
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Est-ce que ce réservoir de carburant est plein ?");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_leak_detected'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("une fuite est présente");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Si une fuite est détectée");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_computer_ok'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("les systèmes électroniques fonctionnent");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Vérifie que toute l'informatique marche");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['fix_leak'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Envoyer une équipe pour réparer la fuite et attendre");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Permet de refroidir les circuits pour charger le carburant");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['pause_launch'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Mettre en pause le lancement");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Met en pause le décompte de lancement le temps de réparer la panne");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['go_lift'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Faire monter l'ascenseur avec les astronautes");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Fait monter les 3 astronautes au 320e étage pour embarquer dans la fusée");
 this.setHelpUrl("");
  }
};

/* ACT 2*/


Blockly.Blocks['launch_rocket'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Lancer la fusée");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['engine_power_to'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Mettre la puissance des moteurs à")
        .appendField(new Blockly.FieldNumber(50, 0, 100, 1), "power");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Contrôle la puissance des moteurs");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['separate_stage'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Séparer l'étage courant ");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Séparer l'étage utilisé de la fusée");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_fuel_empty'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("il n'y a plus de carburant dans l'étage");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_in_max_q'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("on est dans la zone de max Q");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Vérifie si on est dans la zone de pression maximale");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_in_orbit'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("on est en orbite");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Vérifie si la fusée est en orbite.");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['enable_manual_mode'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Lancer la simulation en mode manuel");
    this.setColour(0);
 this.setTooltip("");
 this.setHelpUrl("");
  }
};

/* ACT 3 */

Blockly.Blocks['set_lander_power_to'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Mettre la puissance des moteurs à")
        .appendField(new Blockly.FieldNumber(0, 0, 100, 1), "lander_power");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Change la puissance des moteurs de l'aterrisseur");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['lander_speed'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("vitesse verticale");
    this.setOutput(true, "Number");
    this.setColour(230);
 this.setTooltip("renvoie la vitesse verticale du module lunaire");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_lander_landed'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("le module a aluni");
    this.setOutput(true, "Boolean");
    this.setColour(230);
 this.setTooltip("Si le module lunaire est posé sur la lune");
 this.setHelpUrl("");
  }
};










/* ACT 4 */

Blockly.Blocks['activate_camera'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Démarrer la diffusion");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Active la caméra du module lunaire");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['establish_telecoms'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Etablir la communication")
        .appendField(new Blockly.FieldDropdown([["Houston - Amarillo - Rapid City","9"], ["Houston - Little Rock","10"], ["Houston - Jacksonville","14"], ["Little Rock - Norman","16"], ["Little Rock - Atlanta - Jacksonville","18"], ["Norman - Rapid City","4"], ["Norman - Louisville","15"], ["Louisville - Chicago","8"], ["Louisville - Washington","7"], ["Louisville - Richmond","19"], ["Chicago - Rapid City","21"], ["Chicago - Bufallo","6"], ["Bufallo - Washington","5"], ["Jacksonville - Richmond","20"]]), "val");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Fait passer le signal entre deux villes");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['setup_camera_module'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Mettre en place la caméra");
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Déclenche un mécanisme");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['open_hatch'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Ouvrir la trappe du module lunaire");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Ouvre la porte qui permet aux astronautes de sortir");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['activate_moon_signal'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("Envoyer le signal TV vers la Terre");
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Envoie le signal vers la Terre par le biais d'une antenne");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['call_phone'] = {
  init: function() {
    this.appendValueInput("NUM")
        .setCheck(null)
        .appendField("Appeler le téléphone au numéro");
    this.appendDummyInput();
    this.setPreviousStatement(true, null);
    this.setNextStatement(true, null);
    this.setColour(0);
 this.setTooltip("Appel le téléphone au numéro donné");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['is_telecom_working'] = {
  init: function() {
    this.appendDummyInput()
        .appendField("la liaison entre Washington et Louisville fonctionne");
    this.setOutput(true, null);
    this.setColour(230);
 this.setTooltip("");
 this.setHelpUrl("");
  }
};

Blockly.Blocks['count_letter_in_string'] = {
  init: function() {
    this.appendValueInput("text")
        .setCheck("String")
        .appendField("Compter la lettre")
        .appendField(new Blockly.FieldTextInput("a"), "letter")
        .appendField("dans le texte");
    this.setOutput(true, "Number");
    this.setColour(230);
 this.setTooltip("Compte le nombre d'apparitions de cette lettre dans un texte");
 this.setHelpUrl("");
  }
};
