#include "ADC.h"


void adc_setup(){
	// Enable ADC, no auto trigger, /64 prescale (125kHz)
	ADCSRA = (1 << ADEN) | (0 << ADATE) | (1 << ADPS2) | (1 << ADPS1) | (0 << ADPS0);
	// No auto trigger source
	ADCSRB = 0x00;
	// Internal 1.1V reference, right adjust
	ADMUX = (1 << REFS1) | (1 << REFS0) | (0 << ADLAR);
	// Disable PC0-2
	DIDR0 = 0x07;
}

uint16_t adc_read(uint8_t input) {
	// Select the input
	ADMUX = (ADMUX & 0xF0) | (input & 0x0F);
	// Start the conversion
	ADCSRA |= (1 << ADSC);
	// Wait until the end of it
	while (ADCSRA & (1 << ADSC));

	return ADC;
}

