#ifndef PINS_H_
#define PINS_H_


#include "utils.h"
#include "display.h"
#include "ADC.h"

/* Pins
PORTB = HGFEDCBA
PORTC = xRMxx210
PORTD = 4321NOTR
*/

#define _MODE() _GET(PINC, 5)
#define _SET_OK(v) _SET(PORTD, 2, !(v))
#define _SET_NOK(v) _SET(PORTD, 3, !(v))
#define _SET_DIGIT(d) PORTB = (d)
#define _SELECT_DIGIT(p) PORTD = ((PORTD & 0x0F) | ((~(1 << ((p)+4))) & 0xF0))

void system_setup();


#endif /* PINS_H_ */